//
//  GSTransformableElement.h
//  GlyphsCore
//
//  Created by Georg Seifert on 02.02.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSElement.h>
#import <GlyphsCore/GSUserDataProtocol.h>
NS_ASSUME_NONNULL_BEGIN

#ifdef GLYPHS_VIEWER
typedef NSAffineTransform GSSaveAffineTransform;
#endif

@interface GSTransformableElement : GSElement <GSUserDataProtocol> {
  @public
	NSMutableDictionary *_userData;
	NSMutableDictionary *_tempData;
#pragma GSAutoCodeStart ivars

	CGFloat _angle;
	NSPoint _scale;
	CGFloat _slantHorizontal;
	CGFloat _slantVertical;

#pragma GSAutoCodeEnd ivars
}

/** The transformation of the component.

 The values of the struct are:
 {m11, m12, m21, m22, tX, tY}
 this is equivalent to the glif attributes
 {xScale, xyScale, yxScale, yScale, xOffset, yOffset}
 in the same order.
 The initial value is {1,0,0,1,0,0}.
 */
@property (assign, nonatomic) NSAffineTransformStruct transformStruct;
- (void)setTransformStructFast:(NSAffineTransformStruct)newTS round:(CGFloat)grid;

@property (readonly, nonatomic) NSAffineTransform *transform;

// this holds the transformation during linear interpolation. See GSGlyph.linearInterpolateComponents
@property (assign, nonatomic) NSAffineTransformStruct transformStructTemp;

- (NSRect)boundsUnrotated;

#pragma GSAutoCodeStart methods

/// The angle.
@property (nonatomic) CGFloat angle;

/// The scale.
@property (nonatomic) NSPoint scale;

/// The slantHorizontal.
@property (nonatomic) CGFloat slantHorizontal;

/// The slantVertical.
@property (nonatomic) CGFloat slantVertical;
#ifndef GLYPHS_VIEWER
#pragma mark TempData
/**
 a  dictionary that stores data. It will not be written to disk.
 */
@property (nonatomic, strong, nullable) NSDictionary *tempData;

/**
 Adds key/value to tempData. Pass nil as value to remove previous set data

 @param value and object or nil
 @param key the key
 */
- (void)setTempData:(nullable id)value forKey:(nonnull NSString *)key;

/**
 return value for key in tempData

 @param key the key
 @return a value or nil
 */
- (nullable id)tempDataForKey:(nonnull NSString *)key;
#endif

#pragma GSAutoCodeEnd methods

@end

NS_ASSUME_NONNULL_END
